// File: double_v.cp
//
// Description: smart vector implementation for doubles
//
// Copyright 1992, 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library may
//       be used in compiled form without restrictions.  All
//       source rights reserved: Source code to the GUI library
//       can not be distributed (on bulletin boards, or as part
//       of shareware or commercial products) without written
//       permission.
//

#include "double_v.h"

extern "C" { void exit(int); };

// Define constants for the dynamic grow rate for
// double_vect data types and the maximum number
// of elements that a smart double_vect can have:

const int GROW_RATE = 1;
const int MAX_SIZE = 5000;

double_vect::double_vect(void)
{
    size = 10;
    p = new double[size];
}

double_vect::double_vect(int n)
{
    if (n<= 0) {
        cerr << "illegal size for a double_vect = " << n << "\n";
        exit(1);
    }
    size = n;
    p = new double[size];
}

double_vect::double_vect(double a[], int n)
{
    if (n<= 0) {
        cerr << "illeagl size for a double_vect = " << n << "\n";
        exit(1);
    }
    size = n;
    p = new double[size];
    for (int i=0; i<size; i++)  p[i] = a[i];
}

double_vect::double_vect(double_vect &v)
{
    size = v.size;
    p = new double[size];
    for (int i=0; i<size; i++)  p[i] = v.p[i];
}

double & double_vect::operator [] (int i)
{
    if (i < 0) {
        cerr << "illegal index for double_vect = " << i << "\n";
        exit(1);
    }
    if (i > ub()) {
        grow(i);
    }
    return (p[i]);
}

void double_vect::grow(int new_size)
{
    if ((new_size + GROW_RATE) >= MAX_SIZE) {
        cerr << "error in dynamic resizing of a smart double_vect, new size = "
             << (new_size + GROW_RATE) << "\n";
        exit(1);
    }
    double *np = new double[(new_size + GROW_RATE)];
    for (int i=0; i<size; i++)  np[i] = p[i];
    delete p;
    size = (new_size + GROW_RATE);
    p = np;
}

void double_vect::save(char *file_name)
{
    filebuf out_file;
    if (out_file.open(file_name, output)==0) {
//      cerr << "Could not open output file " << file_name << "\n";
        exit(1);
    }
    ostream out_stream(&out_file);
    out_stream << size << "\n";
    for (int i=0; i<size; i++)
        out_stream << p[i] << "\n";
    out_file.close();
}

void double_vect::restore(char *file_name)
{
    filebuf in_file;
    if (in_file.open(file_name, input)==0) {
//      cerr << "Could not open input file " << file_name << "\n";
        exit(1);
    }
    istream in_stream(&in_file);
    in_stream >> size;
    for (int i=0; i<size; i++)
        in_stream >> p[i];
    in_file.close();
}

#if 0

// test code:

main()
{
    cerr << "Start of double_vect test:\n\n";
    double_vect vv(10);
    vv[2] = 2;
    vv[220] = vv[2];  // illegal index !!
    cerr << "Done with test.\n";
}

#endif
